<?php


class PHPExcel_CachedObjectStorage_MemoryGZip extends PHPExcel_CachedObjectStorage_CacheBase implements PHPExcel_CachedObjectStorage_ICache
{
    protected function storeData()
    {
        if ($this->currentCellIsDirty && !empty($this->currentObjectID)) {
            $this->currentObject->detach();
            $this->cellCache[$this->currentObjectID] = gzdeflate(serialize($this->currentObject));
            $this->currentCellIsDirty = false;
        }
        $this->currentObjectID = $this->currentObject = NULL;
    }
    public function addCacheData($pCoord, PHPExcel_Cell $cell)
    {
        if ($pCoord !== $this->currentObjectID && $this->currentObjectID !== NULL) {
            $this->storeData();
        }
        $this->currentObjectID = $pCoord;
        $this->currentObject = $cell;
        $this->currentCellIsDirty = true;
        return $cell;
    }
    public function getCacheData($pCoord)
    {
        if ($pCoord === $this->currentObjectID) {
            return $this->currentObject;
        }
        $this->storeData();
        if (!isset($this->cellCache[$pCoord])) {
            return NULL;
        }
        $this->currentObjectID = $pCoord;
        $this->currentObject = unserialize(gzinflate($this->cellCache[$pCoord]));
        $this->currentObject->attach($this);
        return $this->currentObject;
    }
    public function getCellList()
    {
        if ($this->currentObjectID !== NULL) {
            $this->storeData();
        }
        return $this::getCellList();
    }
    public function unsetWorksheetCells()
    {
        if (!is_null($this->currentObject)) {
            $this->currentObject->detach();
            $this->currentObject = $this->currentObjectID = NULL;
        }
        $this->cellCache = [];
        $this->parent = NULL;
    }
}

?>