<?php


class PHPExcel_Calculation_Token_Stack
{
    private $stack = [];
    private $count = 0;
    public function count()
    {
        return $this->count;
    }
    public function push($type, $value, $reference = NULL)
    {
        $this->stack[$this->count++] = ["type" => $type, "value" => $value, "reference" => $reference];
        if ($type == "Function") {
            $localeFunction = PHPExcel_Calculation::localeFunc($value);
            if ($localeFunction != $value) {
                $this->stack[$this->count - 1]["localeValue"] = $localeFunction;
            }
        }
    }
    public function pop()
    {
        if (0 < $this->count) {
            return $this->stack[--$this->count];
        }
        return NULL;
    }
    public function last($n = 1)
    {
        if ($this->count - $n < 0) {
            return NULL;
        }
        return $this->stack[$this->count - $n];
    }
    public function clear()
    {
        $this->stack = [];
        $this->count = 0;
    }
}

?>