<?php


class PHPMailer
{
    public $Priority = 3;
    public $CharSet = "utf-8";
    public $ContentType = "text/plain";
    public $Encoding = "8bit";
    public $ErrorInfo = "";
    public $From = "root@localhost";
    public $FromName = "Root User";
    public $Sender = "";
    public $Subject = "";
    public $Body = "";
    public $AltBody = "";
    public $WordWrap = 0;
    public $Mailer = "mail";
    public $Sendmail = "/usr/sbin/sendmail";
    public $PluginDir = "";
    public $Version = "1.73";
    public $ConfirmReadingTo = "";
    public $Hostname = "";
    public $Host = "";
    public $Port = 587;
    public $Helo = "";
    public $SMTPAuth = false;
    public $Username = "";
    public $Password = "";
    public $Timeout = 10;
    public $SMTPDebug = false;
    public $SMTPKeepAlive = false;
    public $smtp = NULL;
    public $to = [];
    public $cc = [];
    public $bcc = [];
    public $ReplyTo = [];
    public $attachment = [];
    public $CustomHeader = [];
    public $message_type = "";
    public $boundary = [];
    public $language = [];
    public $error_count = 0;
    public $LE = "\n";
    public function IsHTML($bool)
    {
        if ($bool) {
            $this->ContentType = "text/html";
        } else {
            $this->ContentType = "text/plain";
        }
    }
    public function IsSMTP()
    {
        $this->Mailer = "smtp";
    }
    public function IsMail()
    {
        $this->Mailer = "mail";
    }
    public function IsSendmail()
    {
        $this->Mailer = "sendmail";
    }
    public function IsQmail()
    {
        $this->Sendmail = "/var/qmail/bin/sendmail";
        $this->Mailer = "sendmail";
    }
    public function AddAddress($address, $name = "")
    {
        $cur = count($this->to);
        $this->to[$cur][0] = trim($address);
        $this->to[$cur][1] = $name;
    }
    public function AddCC($address, $name = "")
    {
        $cur = count($this->cc);
        $this->cc[$cur][0] = trim($address);
        $this->cc[$cur][1] = $name;
    }
    public function AddBCC($address, $name = "")
    {
        $cur = count($this->bcc);
        $this->bcc[$cur][0] = trim($address);
        $this->bcc[$cur][1] = $name;
    }
    public function AddReplyTo($address, $name = "")
    {
        $cur = count($this->ReplyTo);
        $this->ReplyTo[$cur][0] = trim($address);
        $this->ReplyTo[$cur][1] = $name;
    }
    public function Send()
    {
        $header = "";
        $body = "";
        $result = true;
        if (count($this->to) + count($this->cc) + count($this->bcc) < 1) {
            $this->SetError($this->Lang("provide_address"));
            return false;
        }
        if (!empty($this->AltBody)) {
            $this->ContentType = "multipart/alternative";
        }
        $this->error_count = 0;
        $this->SetMessageType();
        $header .= $this->CreateHeader();
        $body = $this->CreateBody();
        if ($body == "") {
            return false;
        }
        switch ($this->Mailer) {
            case "sendmail":
                $result = $this->SendmailSend($header, $body);
                break;
            case "mail":
                $result = $this->MailSend($header, $body);
                break;
            case "smtp":
                $result = $this->SmtpSend($header, $body);
                break;
            default:
                $this->SetError($this->Mailer . $this->Lang("mailer_not_supported"));
                $result = false;
                return $result;
        }
    }
    public function SendmailSend($header, $body)
    {
        if ($this->Sender != "") {
            $sendmail = sprintf("%s -oi -f %s -t", $this->Sendmail, $this->Sender);
        } else {
            $sendmail = sprintf("%s -oi -t", $this->Sendmail);
        }
        if (!($mail = @popen($sendmail, "w"))) {
            $this->SetError($this->Lang("execute") . $this->Sendmail);
            return false;
        }
        fputs($mail, $header);
        fputs($mail, $body);
        $result = pclose($mail) >> 8 & 255;
        if ($result != 0) {
            $this->SetError($this->Lang("execute") . $this->Sendmail);
            return false;
        }
        return true;
    }
    public function MailSend($header, $body)
    {
        $to = "";
        for ($i = 0; $i < count($this->to); $i++) {
            if ($i != 0) {
                $to .= ", ";
            }
            $to .= $this->to[$i][0];
        }
        if ($this->Sender != "" && strlen(ini_get("safe_mode")) < 1) {
            $old_from = ini_get("sendmail_from");
            ini_set("sendmail_from", $this->Sender);
            $params = sprintf("-oi -f %s", $this->Sender);
            $rt = @mail($to, @$this->EncodeHeader($this->Subject), $body, $header, $params);
        } else {
            $rt = @mail($to, @$this->EncodeHeader($this->Subject), $body, $header);
        }
        if (isset($old_from)) {
            ini_set("sendmail_from", $old_from);
        }
        if (!$rt) {
            $this->SetError($this->Lang("instantiate"));
            return false;
        }
        return true;
    }
    public function SmtpSend($header, $body)
    {
        include_once $this->PluginDir . "class.smtp.php";
        $error = "";
        $bad_rcpt = [];
        if (!$this->SmtpConnect()) {
            return false;
        }
        $smtp_from = $this->Sender == "" ? $this->From : $this->Sender;
        if (!$this->smtp->Mail($smtp_from)) {
            $error = $this->Lang("from_failed") . $smtp_from;
            $this->SetError($error);
            $this->smtp->Reset();
            return false;
        }
        for ($i = 0; $i < count($this->to); $i++) {
            if (!$this->smtp->Recipient($this->to[$i][0])) {
                $bad_rcpt[] = $this->to[$i][0];
            }
        }
        for ($i = 0; $i < count($this->cc); $i++) {
            if (!$this->smtp->Recipient($this->cc[$i][0])) {
                $bad_rcpt[] = $this->cc[$i][0];
            }
        }
        for ($i = 0; $i < count($this->bcc); $i++) {
            if (!$this->smtp->Recipient($this->bcc[$i][0])) {
                $bad_rcpt[] = $this->bcc[$i][0];
            }
        }
        if (0 < count($bad_rcpt)) {
            for ($i = 0; $i < count($bad_rcpt); $i++) {
                if ($i != 0) {
                    $error .= ", ";
                }
                $error .= $bad_rcpt[$i];
            }
            $error = $this->Lang("recipients_failed") . $error;
            $this->SetError($error);
            $this->smtp->Reset();
            return false;
        }
        if (!$this->smtp->Data($header . $body)) {
            $this->SetError($this->Lang("data_not_accepted"));
            $this->smtp->Reset();
            return false;
        }
        if ($this->SMTPKeepAlive) {
            $this->smtp->Reset();
        } else {
            $this->SmtpClose();
        }
        return true;
    }
    public function SmtpConnect()
    {
        if ($this->smtp == NULL) {
            $this->smtp = new SMTP();
        }
        $this->smtp->do_debug = $this->SMTPDebug;
        $hosts = explode(";", $this->Host);
        $index = 0;
        for ($connection = $this->smtp->Connected(); $index < count($hosts) && !$connection; $index++) {
            if (strstr($hosts[$index], ":")) {
                list($host, $port) = explode(":", $hosts[$index]);
            } else {
                $host = $hosts[$index];
                $port = $this->Port;
            }
            if ($this->smtp->Connect($host, $port, $this->Timeout)) {
                if ($this->Helo != "") {
                    $this->smtp->Hello($this->Helo);
                } else {
                    $this->smtp->Hello($this->ServerHostname());
                }
                if ($this->SMTPAuth && !$this->smtp->Authenticate($this->Username, $this->Password)) {
                    $this->SetError($this->Lang("authenticate"));
                    $this->smtp->Reset();
                    $connection = false;
                }
                $connection = true;
            }
        }
        if (!$connection) {
            $this->SetError($this->Lang("connect_host"));
        }
        return $connection;
    }
    public function SmtpClose()
    {
        if ($this->smtp != NULL && $this->smtp->Connected()) {
            $this->smtp->Quit();
            $this->smtp->Close();
        }
    }
    public function SetLanguage($lang_type, $lang_path = "language/")
    {
        if (file_exists($lang_path . "phpmailer.lang-" . $lang_type . ".php")) {
            include $lang_path . "phpmailer.lang-" . $lang_type . ".php";
        } else {
            if (file_exists($lang_path . "phpmailer.lang-en.php")) {
                include $lang_path . "phpmailer.lang-en.php";
            } else {
                $this->SetError("Could not load language file");
                return false;
            }
        }
        $this->language = $PHPMAILER_LANG;
        return true;
    }
    public function AddrAppend($type, $addr)
    {
        $addr_str = $type . ": ";
        $addr_str .= $this->AddrFormat($addr[0]);
        if (1 < count($addr)) {
            for ($i = 1; $i < count($addr); $i++) {
                $addr_str .= ", " . $this->AddrFormat($addr[$i]);
            }
        }
        $addr_str .= $this->LE;
        return $addr_str;
    }
    public function AddrFormat($addr)
    {
        if (empty($addr[1])) {
            $formatted = $addr[0];
        } else {
            $formatted = $this->EncodeHeader($addr[1], "phrase") . " <" . $addr[0] . ">";
        }
        return $formatted;
    }
    public function WrapText($message, $length, $qp_mode = false)
    {
        $soft_break = $qp_mode ? sprintf(" =%s", $this->LE) : $this->LE;
        $message = $this->FixEOL($message);
        if (substr($message, -1) == $this->LE) {
            $message = substr($message, 0, -1);
        }
        $line = explode($this->LE, $message);
        $message = "";
        for ($i = 0; $i < count($line); $i++) {
            $line_part = explode(" ", $line[$i]);
            $buf = "";
            for ($e = 0; $e < count($line_part); $e++) {
                $word = $line_part[$e];
                if ($qp_mode && $length < strlen($word)) {
                    $space_left = $length - strlen($buf) - 1;
                    if ($e != 0) {
                        if (20 < $space_left) {
                            $len = $space_left;
                            if (substr($word, $len - 1, 1) == "=") {
                                $len--;
                            } else {
                                if (substr($word, $len - 2, 1) == "=") {
                                    $len -= 2;
                                }
                            }
                            $part = substr($word, 0, $len);
                            $word = substr($word, $len);
                            $buf .= " " . $part;
                            $message .= $buf . sprintf("=%s", $this->LE);
                        } else {
                            $message .= $buf . $soft_break;
                        }
                        $buf = "";
                        while (0 < strlen($word)) {
                        }
                    }
                    $len = $length;
                    if (substr($word, $len - 1, 1) == "=") {
                        $len--;
                    } else {
                        if (substr($word, $len - 2, 1) == "=") {
                            $len -= 2;
                        }
                    }
                    $part = substr($word, 0, $len);
                    $word = substr($word, $len);
                    if (0 < strlen($word)) {
                        $message .= $part . sprintf("=%s", $this->LE);
                    } else {
                        $buf = $part;
                    }
                } else {
                    $buf_o = $buf;
                    $buf .= $e == 0 ? $word : " " . $word;
                    if ($length < strlen($buf) && $buf_o != "") {
                        $message .= $buf_o . $soft_break;
                        $buf = $word;
                    }
                }
            }
            $message .= $buf . $this->LE;
        }
        return $message;
    }
    public function SetWordWrap()
    {
        if ($this->WordWrap < 1) {
            return NULL;
        }
        switch ($this->message_type) {
            case "alt":
            case "alt_attachments":
                $this->AltBody = $this->WrapText($this->AltBody, $this->WordWrap);
                break;
            default:
                $this->Body = $this->WrapText($this->Body, $this->WordWrap);
        }
    }
    public function CreateHeader()
    {
        $result = "";
        $uniq_id = md5(uniqid(time()));
        $this->boundary[1] = "b1_" . $uniq_id;
        $this->boundary[2] = "b2_" . $uniq_id;
        $result .= $this->HeaderLine("Date", $this->RFCDate());
        if ($this->Sender == "") {
            $result .= $this->HeaderLine("Return-Path", trim($this->From));
        } else {
            $result .= $this->HeaderLine("Return-Path", trim($this->Sender));
        }
        if ($this->Mailer != "mail") {
            if (0 < count($this->to)) {
                $result .= $this->AddrAppend("To", $this->to);
            } else {
                if (count($this->cc) == 0) {
                    $result .= $this->HeaderLine("To", "undisclosed-recipients:;");
                }
            }
            if (0 < count($this->cc)) {
                $result .= $this->AddrAppend("Cc", $this->cc);
            }
        }
        $from = [];
        $from[0][0] = trim($this->From);
        $from[0][1] = $this->FromName;
        $result .= $this->AddrAppend("From", $from);
        if (($this->Mailer == "sendmail" || $this->Mailer == "mail") && 0 < count($this->bcc)) {
            $result .= $this->AddrAppend("Bcc", $this->bcc);
        }
        if (0 < count($this->ReplyTo)) {
            $result .= $this->AddrAppend("Reply-to", $this->ReplyTo);
        }
        if ($this->Mailer != "mail") {
            $result .= $this->HeaderLine("Subject", $this->EncodeHeader(trim($this->Subject)));
        }
        $result .= sprintf("Message-ID: <%s@%s>%s", $uniq_id, $this->ServerHostname(), $this->LE);
        $result .= $this->HeaderLine("X-Priority", $this->Priority);
        $result .= $this->HeaderLine("X-Mailer", "PHPMailer [version " . $this->Version . "]");
        if ($this->ConfirmReadingTo != "") {
            $result .= $this->HeaderLine("Disposition-Notification-To", "<" . trim($this->ConfirmReadingTo) . ">");
        }
        for ($index = 0; $index < count($this->CustomHeader); $index++) {
            $result .= $this->HeaderLine(trim($this->CustomHeader[$index][0]), $this->EncodeHeader(trim($this->CustomHeader[$index][1])));
        }
        $result .= $this->HeaderLine("MIME-Version", "1.0");
        switch ($this->message_type) {
            case "plain":
                $result .= $this->HeaderLine("Content-Transfer-Encoding", $this->Encoding);
                $result .= sprintf("Content-Type: %s; charset=\"%s\"", $this->ContentType, $this->CharSet);
                break;
            case "attachments":
            case "alt_attachments":
                if ($this->InlineImageExists()) {
                    $result .= sprintf("Content-Type: %s;%s\ttype=\"text/html\";%s\tboundary=\"%s\"%s", "multipart/related", $this->LE, $this->LE, $this->boundary[1], $this->LE);
                } else {
                    $result .= $this->HeaderLine("Content-Type", "multipart/mixed;");
                    $result .= $this->TextLine("\tboundary=\"" . $this->boundary[1] . "\"");
                }
                break;
            case "alt":
                $result .= $this->HeaderLine("Content-Type", "multipart/alternative;");
                $result .= $this->TextLine("\tboundary=\"" . $this->boundary[1] . "\"");
                break;
            default:
                if ($this->Mailer != "mail") {
                    $result .= $this->LE . $this->LE;
                }
                return $result;
        }
    }
    public function CreateBody()
    {
        $result = "";
        $this->SetWordWrap();
        switch ($this->message_type) {
            case "alt":
                $result .= $this->GetBoundary($this->boundary[1], "", "text/plain", "");
                $result .= $this->EncodeString($this->AltBody, $this->Encoding);
                $result .= $this->LE . $this->LE;
                $result .= $this->GetBoundary($this->boundary[1], "", "text/html", "");
                $result .= $this->EncodeString($this->Body, $this->Encoding);
                $result .= $this->LE . $this->LE;
                $result .= $this->EndBoundary($this->boundary[1]);
                break;
            case "plain":
                $result .= $this->EncodeString($this->Body, $this->Encoding);
                break;
            case "attachments":
                $result .= $this->GetBoundary($this->boundary[1], "", "", "");
                $result .= $this->EncodeString($this->Body, $this->Encoding);
                $result .= $this->LE;
                $result .= $this->AttachAll();
                break;
            case "alt_attachments":
                $result .= sprintf("--%s%s", $this->boundary[1], $this->LE);
                $result .= sprintf("Content-Type: %s;%s\tboundary=\"%s\"%s", "multipart/alternative", $this->LE, $this->boundary[2], $this->LE . $this->LE);
                $result .= $this->GetBoundary($this->boundary[2], "", "text/plain", "") . $this->LE;
                $result .= $this->EncodeString($this->AltBody, $this->Encoding);
                $result .= $this->LE . $this->LE;
                $result .= $this->GetBoundary($this->boundary[2], "", "text/html", "") . $this->LE;
                $result .= $this->EncodeString($this->Body, $this->Encoding);
                $result .= $this->LE . $this->LE;
                $result .= $this->EndBoundary($this->boundary[2]);
                $result .= $this->AttachAll();
                break;
            default:
                if ($this->IsError()) {
                    $result = "";
                }
                return $result;
        }
    }
    public function GetBoundary($boundary, $charSet, $contentType, $encoding)
    {
        $result = "";
        if ($charSet == "") {
            $charSet = $this->CharSet;
        }
        if ($contentType == "") {
            $contentType = $this->ContentType;
        }
        if ($encoding == "") {
            $encoding = $this->Encoding;
        }
        $result .= $this->TextLine("--" . $boundary);
        $result .= sprintf("Content-Type: %s; charset = \"%s\"", $contentType, $charSet);
        $result .= $this->LE;
        $result .= $this->HeaderLine("Content-Transfer-Encoding", $encoding);
        $result .= $this->LE;
        return $result;
    }
    public function EndBoundary($boundary)
    {
        return $this->LE . "--" . $boundary . "--" . $this->LE;
    }
    public function SetMessageType()
    {
        if (count($this->attachment) < 1 && strlen($this->AltBody) < 1) {
            $this->message_type = "plain";
        } else {
            if (0 < count($this->attachment)) {
                $this->message_type = "attachments";
            }
            if (0 < strlen($this->AltBody) && count($this->attachment) < 1) {
                $this->message_type = "alt";
            }
            if (0 < strlen($this->AltBody) && 0 < count($this->attachment)) {
                $this->message_type = "alt_attachments";
            }
        }
    }
    public function HeaderLine($name, $value)
    {
        return $name . ": " . $value . $this->LE;
    }
    public function TextLine($value)
    {
        return $value . $this->LE;
    }
    public function AddAttachment($path, $name = "", $encoding = "base64", $type = "application/octet-stream")
    {
        if (!@is_file($path)) {
            $this->SetError($this->Lang("file_access") . $path);
            return false;
        }
        $filename = basename($path);
        if ($name == "") {
            $name = $filename;
        }
        $cur = count($this->attachment);
        $this->attachment[$cur][0] = $path;
        $this->attachment[$cur][1] = $filename;
        $this->attachment[$cur][2] = $name;
        $this->attachment[$cur][3] = $encoding;
        $this->attachment[$cur][4] = $type;
        $this->attachment[$cur][5] = false;
        $this->attachment[$cur][6] = "attachment";
        $this->attachment[$cur][7] = 0;
        return true;
    }
    public function AttachAll()
    {
        $mime = [];
        for ($i = 0; $i < count($this->attachment); $i++) {
            $bString = $this->attachment[$i][5];
            if ($bString) {
                $string = $this->attachment[$i][0];
            } else {
                $path = $this->attachment[$i][0];
            }
            $filename = $this->attachment[$i][1];
            $name = $this->attachment[$i][2];
            $encoding = $this->attachment[$i][3];
            $type = $this->attachment[$i][4];
            $disposition = $this->attachment[$i][6];
            $cid = $this->attachment[$i][7];
            $mime[] = sprintf("--%s%s", $this->boundary[1], $this->LE);
            $mime[] = sprintf("Content-Type: %s; name=\"%s\"%s", $type, $name, $this->LE);
            $mime[] = sprintf("Content-Transfer-Encoding: %s%s", $encoding, $this->LE);
            if ($disposition == "inline") {
                $mime[] = sprintf("Content-ID: <%s>%s", $cid, $this->LE);
            }
            $mime[] = sprintf("Content-Disposition: %s; filename=\"%s\"%s", $disposition, $name, $this->LE . $this->LE);
            if ($bString) {
                $mime[] = $this->EncodeString($string, $encoding);
                if ($this->IsError()) {
                    return "";
                }
                $mime[] = $this->LE . $this->LE;
            } else {
                $mime[] = $this->EncodeFile($path, $encoding);
                if ($this->IsError()) {
                    return "";
                }
                $mime[] = $this->LE . $this->LE;
            }
        }
        $mime[] = sprintf("--%s--%s", $this->boundary[1], $this->LE);
        return join("", $mime);
    }
    public function EncodeFile($path, $encoding = "base64")
    {
        if (!($fd = @fopen($path, "rb"))) {
            $this->SetError($this->Lang("file_open") . $path);
            return "";
        }
        $magic_quotes = get_magic_quotes_runtime();
        set_magic_quotes_runtime(0);
        $file_buffer = fread($fd, filesize($path));
        $file_buffer = $this->EncodeString($file_buffer, $encoding);
        fclose($fd);
        set_magic_quotes_runtime($magic_quotes);
        return $file_buffer;
    }
    public function EncodeString($str, $encoding = "base64")
    {
        $encoded = "";
        strtolower($encoding);
        switch (strtolower($encoding)) {
            case "base64":
                $encoded = chunk_split(base64_encode($str), 76, $this->LE);
                break;
            case "7bit":
            case "8bit":
                $encoded = $this->FixEOL($str);
                if (substr($encoded, -1 * strlen($this->LE)) != $this->LE) {
                    $encoded .= $this->LE;
                }
                break;
            case "binary":
                $encoded = $str;
                break;
            case "quoted-printable":
                $encoded = $this->EncodeQP($str);
                break;
            default:
                $this->SetError($this->Lang("encoding") . $encoding);
                return $encoded;
        }
    }
    public function EncodeHeader($str, $position = "text")
    {
        $x = 0;
        strtolower($position);
        switch (strtolower($position)) {
            case "phrase":
                if (!preg_match("/[\\200-\\377]/", $str)) {
                    $encoded = addcslashes($str, "\0..\37\\\"");
                    if ($str == $encoded && !preg_match("/[^A-Za-z0-9!#\$%&'*+\\/=?^_`{|}~ -]/", $str)) {
                        return $encoded;
                    }
                    return "\"" . $encoded . "\"";
                }
                $x = preg_match_all("/[^\\040\\041\\043-\\133\\135-\\176]/", $str, $matches);
                break;
            case "comment":
                $x = preg_match_all("/[()\"]/", $str, $matches);
                break;
            case "text":
            default:
                $x += preg_match_all("/[\\000-\\010\\013\\014\\016-\\037\\177-\\377]/", $str, $matches);
                if ($x == 0) {
                    return $str;
                }
                $maxlen = 68 - strlen($this->CharSet);
                if (strlen($str) / 3 < $x) {
                    $encoding = "B";
                    $encoded = base64_encode($str);
                    $maxlen -= $maxlen % 4;
                    $encoded = trim(chunk_split($encoded, $maxlen, "\n"));
                } else {
                    $encoding = "Q";
                    $encoded = $this->EncodeQ($str, $position);
                    $encoded = $this->WrapText($encoded, $maxlen, true);
                    $encoded = str_replace("=" . $this->LE, "\n", trim($encoded));
                }
                $encoded = preg_replace("/^(.*)\$/m", " =?" . $this->CharSet . "?" . $encoding . "?\\1?=", $encoded);
                $encoded = trim(str_replace("\n", $this->LE, $encoded));
                return $encoded;
        }
    }
    public function EncodeQP($str)
    {
        $encoded = $this->FixEOL($str);
        if (substr($encoded, -1 * strlen($this->LE)) != $this->LE) {
            $encoded .= $this->LE;
        }
        $encoded = preg_replace("/([\\000-\\010\\013\\014\\016-\\037\\075\\177-\\377])/e", "'='.sprintf('%02X', ord('\\1'))", $encoded);
        $encoded = preg_replace("/([\t ])" . $this->LE . "/e", "'='.sprintf('%02X', ord('\\1')).'" . $this->LE . "'", $encoded);
        $encoded = $this->WrapText($encoded, 74, true);
        return $encoded;
    }
    public function EncodeQ($str, $position = "text")
    {
        $encoded = preg_replace("[\r\n]", "", $str);
        strtolower($position);
        switch (strtolower($position)) {
            case "phrase":
                $encoded = preg_replace("/([^A-Za-z0-9!*+\\/ -])/e", "'='.sprintf('%02X', ord('\\1'))", $encoded);
                break;
            case "comment":
                $encoded = preg_replace("/([\\(\\)\"])/e", "'='.sprintf('%02X', ord('\\1'))", $encoded);
                break;
            case "text":
            default:
                $encoded = preg_replace("/([\\000-\\011\\013\\014\\016-\\037\\075\\077\\137\\177-\\377])/e", "'='.sprintf('%02X', ord('\\1'))", $encoded);
                $encoded = str_replace(" ", "_", $encoded);
                return $encoded;
        }
    }
    public function AddStringAttachment($string, $filename, $encoding = "base64", $type = "application/octet-stream")
    {
        $cur = count($this->attachment);
        $this->attachment[$cur][0] = $string;
        $this->attachment[$cur][1] = $filename;
        $this->attachment[$cur][2] = $filename;
        $this->attachment[$cur][3] = $encoding;
        $this->attachment[$cur][4] = $type;
        $this->attachment[$cur][5] = true;
        $this->attachment[$cur][6] = "attachment";
        $this->attachment[$cur][7] = 0;
    }
    public function AddEmbeddedImage($path, $cid, $name = "", $encoding = "base64", $type = "application/octet-stream")
    {
        if (!@is_file($path)) {
            $this->SetError($this->Lang("file_access") . $path);
            return false;
        }
        $filename = basename($path);
        if ($name == "") {
            $name = $filename;
        }
        $cur = count($this->attachment);
        $this->attachment[$cur][0] = $path;
        $this->attachment[$cur][1] = $filename;
        $this->attachment[$cur][2] = $name;
        $this->attachment[$cur][3] = $encoding;
        $this->attachment[$cur][4] = $type;
        $this->attachment[$cur][5] = false;
        $this->attachment[$cur][6] = "inline";
        $this->attachment[$cur][7] = $cid;
        return true;
    }
    public function InlineImageExists()
    {
        $result = false;
        $i = 0;
        while ($i < count($this->attachment)) {
            if ($this->attachment[$i][6] == "inline") {
                $result = true;
            } else {
                $i++;
            }
        }
        return $result;
    }
    public function ClearAddresses()
    {
        $this->to = [];
    }
    public function ClearCCs()
    {
        $this->cc = [];
    }
    public function ClearBCCs()
    {
        $this->bcc = [];
    }
    public function ClearReplyTos()
    {
        $this->ReplyTo = [];
    }
    public function ClearAllRecipients()
    {
        $this->to = [];
        $this->cc = [];
        $this->bcc = [];
    }
    public function ClearAttachments()
    {
        $this->attachment = [];
    }
    public function ClearCustomHeaders()
    {
        $this->CustomHeader = [];
    }
    public function SetError($msg)
    {
        $this->error_count++;
        $this->ErrorInfo = $msg;
    }
    public function RFCDate()
    {
        $tz = date("Z");
        $tzs = $tz < 0 ? "-" : "+";
        $tz = abs($tz);
        $tz = $tz / 3600 * 100 + $tz % 3600 / 60;
        $result = sprintf("%s %s%04d", date("D, j M Y H:i:s"), $tzs, $tz);
        return $result;
    }
    public function ServerVar($varName)
    {
        global $HTTP_SERVER_VARS;
        global $HTTP_ENV_VARS;
        if (!isset($_SERVER)) {
            $_SERVER = $HTTP_SERVER_VARS;
            if (!isset($_SERVER["REMOTE_ADDR"])) {
                $_SERVER = $HTTP_ENV_VARS;
            }
        }
        if (isset($_SERVER[$varName])) {
            return $_SERVER[$varName];
        }
        return "";
    }
    public function ServerHostname()
    {
        if ($this->Hostname != "") {
            $result = $this->Hostname;
        } else {
            if ($this->ServerVar("SERVER_NAME") != "") {
                $result = $this->ServerVar("SERVER_NAME");
            } else {
                $result = "localhost.localdomain";
            }
        }
        return $result;
    }
    public function Lang($key)
    {
        if (count($this->language) < 1) {
            $this->SetLanguage("en");
        }
        if (isset($this->language[$key])) {
            return $this->language[$key];
        }
        return "Language string failed to load: " . $key;
    }
    public function IsError()
    {
        return 0 < $this->error_count;
    }
    public function FixEOL($str)
    {
        $str = str_replace("\r\n", "\n", $str);
        $str = str_replace("\r", "\n", $str);
        $str = str_replace("\n", $this->LE, $str);
        return $str;
    }
    public function AddCustomHeader($custom_header)
    {
        $this->CustomHeader[] = explode(":", $custom_header, 2);
    }
}

?>